#!/bin/sh

# THIS PRODUCT CONTAINS RESTRICTED MATERIALS OF IBM
# IBM Confidential OCO Source Material
# 5639-D57, 5630-A36, 5630-A37, 5724-D18 (C) COPYRIGHT International Business Machines Corp., 1997,2002
# The source code for this program is not published or otherwise divested
# of its trade secrets, irrespective of what has been deposited with the
# U.S. Copyright Office.
# All Rights Reserved * Licensed Materials - Property of IBM
# US Government Users Restricted Rights - Use, duplication or disclosure
# restricted by GSA ADP Schedule Contract with IBM Corp.

# Configuration Based Server Launcher

# Launch Arguments:
#
# serverName     - the name of the server process to be launched.
# -script [script_file_name] 
# -nowait 
# -quiet 
# -trace 
# -timeout <time>
# -statusport <port>
#

set_script_executable()
{
  scriptfile=start_$1.sh
  while [ "$#" -gt "0" ]
  do
    # check for -script option
    if [ "$1" = "-script" ]
    then
       # check the next argument for explicit script name
       if [ $# -gt "1" ]
       then
          shift
          # if the argument begins with "-", ignore it
          # because it is not a script file name
          if [ `echo "$1" | cut -c 1` != "-" ]
          then
             scriptfile="$1"
          fi
       fi
       # make sure the file does exist before setting exec permission
       if [ -f $scriptfile ]
       then
          chmod +x $scriptfile
       fi
    fi
    shift
  done
}


# Bootstrap values ...
SHELL=com.ibm.ws.management.tools.WsServerLauncher 

binDir=`dirname $0`
. $binDir/setupCmdLine.sh

# For debugging the launcher itself
# DEBUG="-Djava.compiler=NONE -Xdebug -Xnoagent -Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=7777"


# Setup the initial java invocation;

PLATFORM=`/bin/uname`
case $PLATFORM in
  AIX)
    EXTSHM=ON
    LIBPATH="$WAS_LIBPATH":$LIBPATH
    export LIBPATH EXTSHM ;;
  Linux)
    LD_LIBRARY_PATH="$WAS_LIBPATH":$LD_LIBRARY_PATH
    export LD_LIBRARY_PATH ;;
  SunOS)
    LD_LIBRARY_PATH="$WAS_LIBPATH":$LD_LIBRARY_PATH
    export LD_LIBRARY_PATH ;;
  HP-UX)
    SHLIB_PATH="$WAS_LIBPATH":$SHLIB_PATH
    export SHLIB_PATH ;;
esac

"$JAVA_HOME"/bin/java \
  $DEBUG \
  -Dws.ext.dirs="$WAS_EXT_DIRS" \
  -classpath "$WAS_CLASSPATH" \
  -Dwas.install.root="$WAS_HOME" \
  $USER_INSTALL_PROP \
  com.ibm.ws.bootstrap.WSLauncher \
  $SHELL "$CONFIG_ROOT" "$WAS_CELL" "$WAS_NODE" "$@"

launchExit=$?
if [ "$launchExit" = "0" ]
then
  set_script_executable $@
fi
exit `expr $launchExit + $?`
~
